/* 
 * 
 * 
 */
//auxiliary JavaScript for eHouse control via SVG graphics (drawing object + aprox 2:1 compression)
//author http://www.isys.pl/
var EHOUSE1_VIA_CM            = 1;          //Ehouse1 controllers via CM (under CommManager supervision)
var xmlns="http://www.w3.org/2000/svg",xlink="http://www.w3.org/1999/xlink";
var Root=document.documentElement;
var BacgroundColor=0;
var transparencyopacity=.1;
var fill_opacity=.5;
var stroke_opacity=.5;
var DecimalSeparator = Number("1.2").toLocaleString().substr(1,1);
var eHouse1=new Array();        //ehouse 1 status array
var EthernetEhouse=new Array(); //Ethernet Ehouse status Array
//create eHouse1 single Object and initialize data
//Global Constants for compatibility defined as VAR
var MAX_EHOUSE1_DEVS=15,            //Maximal count of ehouse1 devices
MAX_ETHERNET_EHOUSE_DEVS=15;        //Maximal count of EthernetEhoue devices

var None=0,IsRM=1,IsEM=2,IsHM=3,    //device TYPE RoomManager,ExternalManager,HeatManager
IsERM=1,IsCommManager=2,IsLevelManager=3,IsEHM =4,IsEEM=5,  //Ethernet Device type EthernetRoomManager,... EthernetHeatManager

    //eHouse1 Indexes offset
    STATUS_OFFSET=2,                       //offset for status locations in binary buffer
                                            //byte index location of binary status query results
    RM_STATUS_ADC                 = 1  + STATUS_OFFSET,    //start of adc measurement
    RM_STATUS_OUT                 = 17 + STATUS_OFFSET,    //RM start of outputs
    HM_STATUS_OUT                 = 33 + STATUS_OFFSET,    //HM start of outputs
    RM_STATUS_IN                  = 20 + STATUS_OFFSET,    //RM start of inputs
    RM_STATUS_INT                 = 21 + STATUS_OFFSET,    //rm start of inputs (fast)
    RM_STATUS_OUT25               = 22 + STATUS_OFFSET,    //rm starts of outputs => 25-32
    RM_STATUS_LIGHT               = 23 + STATUS_OFFSET,    //rm light level start
    RM_STATUS_ZONE_PGM            = 26 + STATUS_OFFSET,    //rm current zone
    RM_STATUS_PROGRAM             = 27 + STATUS_OFFSET,    //rm current program
    RM_STATUS_INPUTEXT_A_ACTIVE   = 28 + STATUS_OFFSET,    //em input extenders A status active inputs
    RM_STATUS_INPUTEXT_B_ACTIVE   = 32 + STATUS_OFFSET,    //em input extenders B status active inputs
    RM_STATUS_INPUTEXT_C_ACTIVE   = 36 + STATUS_OFFSET,    //em input extenders C status active inputs
    RM_STATUS_INPUTEXT_A          = 40 + STATUS_OFFSET,    //em --||-
    RM_STATUS_INPUTEXT_B          = 50 + STATUS_OFFSET,    //em 
    RM_STATUS_INPUTEXT_C          = 60 + STATUS_OFFSET,    //em 
    HM_STATUS_PROGRAM             = 36 + STATUS_OFFSET,    //hm current program
    HM_STATUS_KOMINEK             = 46 + STATUS_OFFSET,    //hm status bonfire
    HM_STATUS_RECU                = 48 + STATUS_OFFSET,    //hm status recu
    HM_WENT_MODE		  = 49 + STATUS_OFFSET,    //hm went mode

//Size of resources for eHouse controllers
    OUTPUTS_COUNT_RM              = 35,        //maximal number of outputs
    OUTPUTS_COUNT_ERM             = 80,//160,       //maximal nr of outputs for ethernet devices
    SENSORS_COUNT_RM              = 16,        //maximal number of ADCs
    SENSORS_COUNT_ERM             = 16,        //maximal number of ADCs for ethernet devices
    ALARM_SENSORS_COUNT_ERM       = 48,         //96 maximal number of alarm sensors for CM 
    INPUTS_COUNT_RM               = 16,         //maximal number of Inputs
    INPUTS_COUNT_ERM              = 48,//96,         //Maximal nr of inputs for ethernet devices
    DIMMERS_COUNT_RM              = 3;          //dimers count
    
                 
    //
    //Ethernet eHouse indexes CM, ERM,EHM
    //INDEXES in current status buffer (binary status information) / location information       
       var STATUS_TCP_OFFSET=2,                   //offset in current status for data
        STATUS_COMMMANAGER_OFFSET      =70,    //offset for storing CommManager status attached to eHouse 1 devices status in hybrid mode
                                                //Ehouse1 under CommManager supervisor
//in reference to STATUS_COMMMANAGER_OFFSET each ethernet controllers
        STATUS_ADC_ETH			=0,    			//adc values * 2B
        STATUS_ADC_ETH_END		=32,                    //end of adc values
//STATUS_OUT_ETH			=STATUS_ADC_ETH_END;	//4*8 32		
//STATUS_INPUTS			=STATUS_OUT_ETH+4;		//4*8 32		
        STATUS_OUT_I2C			=STATUS_ADC_ETH_END,        //i2c output buffers states  //max=160 outputs
        STATUS_INPUTS_I2C		=STATUS_OUT_I2C+20,         //i2c input buffers states //max 96 inputs
        STATUS_ALARM_I2C		=STATUS_INPUTS_I2C+12,      //--|--- for alarm states in case of CM
        STATUS_WARNING_I2C		=STATUS_ALARM_I2C+12,       //--|--- for warning states in case of CM
        STATUS_MONITORING_I2C	        =STATUS_WARNING_I2C+12,     //--|--- for monitoring states in case of CM
        STATUS_PROGRAM_NR		=STATUS_MONITORING_I2C+12,  //--|--- for alarm states in case of CM
        STATUS_ZONE_NR			=STATUS_PROGRAM_NR+1,       //current program no.
        STATUS_ADC_PROGRAM		=STATUS_ZONE_NR+1,          //current adc program no.
        STATUS_LIGHT_LEVEL		=STATUS_ADC_PROGRAM+2;		//dimmer levels

    
    var IgnoreAtChar              = 1     //ignore outputs,inputs, signals with @ char in names
    ;
var MCP9700_Offset=-500.0; //Offset voltage at 0C [mV]
var MCP9701_Offset=-400.0; //Offset voltage at 0C [mV]
var MCP9700x=10000.0;   // uV/C
var MCP9701x=19500.0;   // uV/C
var COMMANAGER_HIGH=0;//CommManager High
var COMMANAGER_LOW=254;//CommManager Low
                 
//size of eHouse1 controllers
for (var ii=0;ii<MAX_EHOUSE1_DEVS;ii+=1)
    eHouse1Create(ii);
for (var ii=0;ii<MAX_ETHERNET_EHOUSE_DEVS+1;ii+=1)      //Last for CommManager, EthernetEhouse[0] - for EthernetHeatManager
    EthernetEhouseCreate(ii);
//status received as text from html get/post method    
eHouse1[1].Stat='B23701002B025F026103FF03FF03FF03FF03FF5555010000FFFFFFFF0000000000000000000000000000000000000000000000006DFEFE3701730000000000000000000000000000000500020000000500010001000200010002000200030001000200010003000120000000A8010000000000000000000000000000432440E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000012';
//eHouse1[1].Stat='B237010016025E026003FF03FF03FF03FF03FF0000000000FFFFFFFF0005000000000000000000000000000000000000000000006DFEFE3701730000000000000000000000000000000000020004000500020002000300020003000100030001000300010003000220000000A8010000000000000000000000000000432440E60BFE0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011';
GetEhouse1Status(1);
EthernetEhouse[1].Stat='B400C97300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000250D170C04060D0000000000000000000218023400070309000400040004000400F1000503EB03FF03FF03FF03FF03FFAAAAAAAA00000000000000000000000000000000FF0F0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000D';
GetEthernetEhouseStatus(1);

//GetEthernetEhouseStatus(MAX_ETHERNET_EHOUSE_DEVS);
////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//decode binary status to data and put to eHouse1[index]
function GetEhouse1Status(index)
{
if (eHouse1[index].PrevStat===eHouse1[index].Stat) return;   //the same data - no update from recent call
eHouse1[index].PrevStat=eHouse1[index].Stat;                //Update Previous state to ignore if no data reception for current controller
//if (EHOUSE1_VIA_CM)             //if eHouse under commManager supervision

hex2bin(index); //convert text - hex status to binary data -> eHouse1[index].BinStat;
DecodeEh1Status(index); //decode status of eHouse1 controller from binary status data
ShoweHouse1Status(index);
}
///////////////////////////////////////////////////////////////////////////////
var xhr = new XMLHttpRequest();
var CurrentIndexBinaryStatus=0;
//convert text-hex coded status string to binary for eHouse1[index] controller
function hex2bin(index)
{
var temp_length=eHouse1[index].Stat.length,
    tmp=eHouse1[index].Stat,
 m=0,
 i=0,
 k=0;
 
 for (i=0;i<temp_length;i+=2)
     {
        
        
         m=parseInt(tmp[i], 16)*16+parseInt(tmp[i+1],16);   //decode hex values eg 'FE' to binary data
         if (i===0) eHouse1[index].Size=m;
 //        else
             {
             if (k===1) eHouse1[index].AddrH=m;
             if (k===2) eHouse1[index].AddrL=m;
             eHouse1[index].BinStat[k]=m;
            if (EHOUSE1_VIA_CM)             
                 EthernetEhouse[MAX_ETHERNET_EHOUSE_DEVS].BinStat[k]=m;
             k++;
             }
     }
     
     if (eHouse1[index].AddrH===1) eHouse1[index].Type=IsHM;
     if (eHouse1[index].AddrH===2) eHouse1[index].Type=IsEM;
     if (eHouse1[index].AddrH===55) eHouse1[index].Type=IsRM;
     if (eHouse1[index].Type>0) //type eHouse1 RM|HM|EM
        if (EHOUSE1_VIA_CM)             //if eHouse1 under commmanager supervision
            {                           //status of CommManager are attached so we imediatelly perform it
            EthernetEhouse[MAX_ETHERNET_EHOUSE_DEVS].AddrH=COMMANAGER_HIGH;     //Overwrite CommManager Address over eHouse1 Addr
            EthernetEhouse[MAX_ETHERNET_EHOUSE_DEVS].AddrL=COMMANAGER_LOW;  
            EthernetEhouse[MAX_ETHERNET_EHOUSE_DEVS].Type=IsCommManager;        //type CommManager
            EthernetEhouse[MAX_ETHERNET_EHOUSE_DEVS].Stat=eHouse1[index].Stat;  //Copy TextStatus
            GetEthernetEhouseStatus(MAX_ETHERNET_EHOUSE_DEVS);                  //Perform CommManager status update
            }
}
//////////////////////////////////////////////////////////////////////////////////
//Hex 2 bin Ethernet Version decode status > store to EthernetEhouse[index]
function hex2binEth(index)
{
var temp_length=EthernetEhouse[index].Stat.length,
    tmp=EthernetEhouse[index].Stat,
 m=0,
 i=0,
 k=0,str="";
 
 while (i<temp_length)
     {
        str=tmp[i]+tmp[i+1];
         m=parseInt(str, 16);//*16;
//         m+=parseInt(tmp[i+1],16);   //decode hex values eg 'FE' to binary data
         if (k===0) EthernetEhouse[index].Size=m;
 //        else
             {
             if (k===1) EthernetEhouse[index].AddrH=m;
             if (k===2) EthernetEhouse[index].AddrL=m;
             EthernetEhouse[index].BinStat[k]=m;
             k++;
             }
             i=i+2;
     }
     EthernetEhouse[index].Type=IsERM;
     if (EthernetEhouse[index].AddrL>=250) EthernetEhouse[index].Type=IsCommManager;                       
     if ((EthernetEhouse[index].AddrH===2) || (EthernetEhouse[index].AddrH===55) || (EthernetEhouse[index].AddrH===1)) 
        {     
            EthernetEhouse[index].AddrH=COMMANAGER_HIGH;
            EthernetEhouse[index].AddrL=COMMANAGER_LOW;
            EthernetEhouse[index].Type=IsCommManager;
        }
}







//////////////////////////////////////////////////////////////////////////////////
//Get templm35 temperature sensol value
function gettemplm35(dta,VCC)
    {
    var temp;
    temp=(dta*VCC/(1023*10));
//t=Math.Round(temp*10);
//temp=(t/10);
    temp = Math.round(temp*10);
    temp/=10;
    return temp;
    }

////////////////////////////////////////////////////////////////////////
//binary to hex coded string
function d2h(tmp)
{
var table="0123456789ABCDEF",
 res="",
temp=tmp&0x0f,
temp2=tmp>>4;
res=table[temp2]+table[temp];
return res;
}
///////////////////////////////////////////////////////////////////////////////
//
/*function stringToHex (tmp) {
    var str = '',
    i = 0,
    tmp_len = tmp.length,
    c;
     
    for (; i < tmp_len; i += 1) {
    c = tmp.charCodeAt(i);
    str += d2h(c) + ' ';
    }
    return str;
    }*/
  ///////////////////////////////////////////////////////////////////////////////  
function hix(str,size)
    {
        var res="";
        for (var i=0;i<size;i++)
            {
            c = str[i];                
            res += d2h(c) + '';    
            
            }
    return res;            
    }
//////////////////////////////////////////////////////////////////////////////////    
    function hexToString (tmp) {
    var arr = tmp.split(' '),
    str = '',
    i = 0,
    arr_len = arr.length,
    c;
     
    for (; i < arr_len; i += 1) {
    c = String.fromCharCode( h2d( arr[i] ) );
    str += c;
    }
     document.writeln(str);
    return str;
    }

//Send status query request for controller Index
////////////////////////////////////////////////////////////////////////////////
function GetStatus(i)
{
    CurrentIndexBinaryStatus=i;

xhr.open('GET', '/eh?'+CurrentIndexBinaryStatus, true);
xhr.responseType = 'arraybuffer';
};
//Event on reception response
xhr.onload = function(e) {
    



var Uint8Array=new Uint8Array(this.response);
for (i=0;i<SizeOf(Uint8Array);i+=2)
    StatusMatrixEhouseOne[CurrentIndexBinaryStatus]
};
/////////////////////////////////////////////////////
//Get True/False Value of current output / input / etc - logical state
function GetInOutValue(dta, offset)
    {
    var temp=dta>>offset;
    if ((temp & 0x01)>0) 
            return true;
    else return false;
    }
////////////////////////////////////////////////////////////////////////////////
function DecodeEh1Status(index)

        { 
        var    i=0,k=0,
        Max_ADC = 8;

//        Calendar c = Calendar.getInstance(); 
  //      recent=c.getTime().toLocaleString();
     
 //       if (changed) //data changed or unconditional
        {   //update data
    
        if ((eHouse1[index].Type===IsRM) || (eHouse1[index].Type===IsEM)) 
            {
            Max_ADC=8;           
            for (k = 0; k < 8; k++) //update output and input states and visualization objects
                {
                    
                    eHouse1[index].Outs[k]      = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_OUT]&0xff, k); //outputs
                    eHouse1[index].Outs[k + 8]  = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_OUT + 1]&0xff, k); 
                    eHouse1[index].Outs[k + 16] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_OUT + 2]&0xff, k); 
                    eHouse1[index].Outs[k + 24] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_OUT25]&0xff, k); 
                    eHouse1[index].Inputs[k]    = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_IN]&0xff, k);  //inputs
                    eHouse1[index].Inputs[k+8]  = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INT]&0xff, k);
                if (eHouse1[index].Type===IsEM)   //for em additionally update input extenders alarm sensor inputs states and visualization objects
                    {
                    eHouse1[index].AlarmSensorsActive[k] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A_ACTIVE]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 8] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A_ACTIVE + 1]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 16] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A_ACTIVE + 2]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 24] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A_ACTIVE + 3]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 32] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A + 4]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 40] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B_ACTIVE + 0]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 48] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B_ACTIVE + 1]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 56] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B_ACTIVE + 2]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 64] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B_ACTIVE + 3]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 72] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 4]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 80] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_C_ACTIVE + 0]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 88] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_C_ACTIVE + 1]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 96] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_C_ACTIVE + 2]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 104] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_C_ACTIVE + 3]&0xff, k);
                    eHouse1[index].AlarmSensorsActive[k + 112] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_C + 4]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 8] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A + 1]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 16] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A + 2]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 24] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A + 3]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 32] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_A + 4]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 40] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 0]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 48] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 1]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 56] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 2]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 64] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 3]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 72] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 4]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 80] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 0]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 88] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 1]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 96] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 2]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 104] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 3]&0xff, k);
                    eHouse1[index].AlarmSensorsAlarm[k + 112] = GetInOutValue(eHouse1[index].BinStat[RM_STATUS_INPUTEXT_B + 4]&0xff, k);
                    }
                }

            eHouse1[index].CurrentProgram=eHouse1[index].BinStat[RM_STATUS_PROGRAM]&0xff;    //update current program nr
            eHouse1[index].CurrentZone = eHouse1[index].BinStat[RM_STATUS_ZONE_PGM]&0xff;    //update current zone
            }
        if (eHouse1[index].Type===IsHM)   //heatmanager
            {
            Max_ADC=16;
            eHouse1[index].CurrentProgram = eHouse1[index].BinStat[HM_STATUS_PROGRAM]&0xff;  //current program for heatmanager
            for (k = 0; k < 8; k++) //update output states and visualization objects
                {
                eHouse1[index].Outs[k] = GetInOutValue(eHouse1[index].BinStat[HM_STATUS_OUT]&0xff, k);
                eHouse1[index].Outs[k + 8] = GetInOutValue(eHouse1[index].BinStat[HM_STATUS_OUT + 1]&0xff, k);
                eHouse1[index].Outs[k + 16] = GetInOutValue(eHouse1[index].BinStat[HM_STATUS_OUT + 2]&0xff, k);
                eHouse1[index].Outs[k + 24] =false;
                eHouse1[index].Inputs[k ] =false;
                eHouse1[index].Inputs[k + 8] =false;
                }
            }
        i=0;
        while (i < Max_ADC)         //perform all adc results (2bytes per result)
                {                                               //offset od 2                       //offset od 2
                //int temppp=(CurrentStatus[i * 2 + 2] << 8) + CurrentStatus[i * 2 + 1 + 2];
                var temppp= eHouse1[index].BinStat[i * 2 + RM_STATUS_ADC+1 ]&0xff;
                if (temppp<0) temppp+=256;
                temppp+=((eHouse1[index].BinStat[RM_STATUS_ADC+i * 2 ]&0xff) << 8);
                eHouse1[index].ADCs[i] = temppp;    //update value
                eHouse1[index].SensorTemps[i] = gettemplm(temppp, eHouse1[index].Calibration[i], 10, eHouse1[index].VCC);    //calculate temp value
               //SensorLights[i] = getlight(temppp); //calculate light level value
                eHouse1[index].SensorPercents[i] = calculate_percent(temppp);  //calculate percent value
                eHouse1[index].SensorLights[i]=100- eHouse1[index].SensorPercents[i];
                eHouse1[index].SensorVolts[i]=calculate_voltage(temppp,eHouse1[index].VCC);
                i++;
               }
        //for (var ii=0;ii<DIMMERS_RGB_COUNT_RM;ii++) 
            eHouse1[index].DimmerRGB=0;
        
        for (var ii=0;ii<DIMMERS_COUNT_RM;ii++)         //set dimmer values for single dimmer and RGB consists of 3 single
            {
             eHouse1[index].DimmerRGB[ii/3]= eHouse1[index].BinStat[RM_STATUS_LIGHT+(ii%3)]&0xff;
            if ((ii%3)!==2) 
                     eHouse1[index].DimmerRGB[ii/3]= eHouse1[index].DimmerRGB[ii/3]<<8;
             eHouse1[index].Dimmers[ii]=  eHouse1[index].BinStat[RM_STATUS_LIGHT+(ii)]&0xff;
             }
        
        }
        }
////////////////////////////////////////////////////////////////////////////////////////
//Calculate Temperature for MCP9700 sensor for Ethernet eHouse controllers 
function calculate_MCP9700Eth(dta,VCC,Calibration)
            {
            var tmp = (((dta *  VCC ) / 1023))+Calibration;
             //get temp in [C]
            tmp=(Math.round((tmp/MCP9700x)*10*1000)*1.0)/10;
            return tmp;
            }
/////////////////////////////////////////////////////////////////////////
//Calculate Temperature for MCP9701 sensor for Ethernet eHouse controllers 
function calculate_MCP9701Eth(dta,VCC,Calibration)
            {
            var tmp = (((dta *  VCC ) / 1023))+Calibration;//MCP9701_Offset ;
             //get temp in [C]
            tmp=(Math.round((tmp/MCP9701x)*10*1000)*1.0)/10;
            return tmp;
            }        
///calculate LM335 termometer value consider calibration
function gettemplm(dta, calibration, k, VCC)
    {
    var temp=0.00;
    temp=(dta*VCC/(1023*k))+calibration/100;
    temp = (((Math.round(temp*10))*1.0)/10);
    return temp;
    }
//    calculate percent value
function calculate_percent(dta)
            {
            return (Math.round(((dta * 100 ) / 1023)*100))/100;  //rounding to  2 digits of fractional part
            }
//calculate voltage comparing to VCC
function calculate_voltage(dta,VCC)
            {
            var tmp = Math.round(((dta *  VCC ) / 1023)*100);//up ot  2 decimal fractional digits
            tmp=tmp/100000;
            return tmp;
            }
/////////////////////////////////////////////////////////////////////////////////////
/// Execute event via email 2 functions
/////////////////////////////////////////////////////////////////////////////////////
function x(text)
{
window.open('em.php?x='+text+'&m=ftp','Sending Event: '+text,'width=750,height=200,resizable=yes,scrollbars=yes,toolbar=no,location=no,directories=no,status=yes,menubar=no,copyhistory=no');
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function exec(name,state,newstate,event,directevent)
{
window.open('em.php?x='+name,'Sending Event: '+name,'width=750,height=200,resizable=yes,scrollbars=yes,toolbar=no,location=no,directories=no,status=yes,menubar=no,copyhistory=no');
}
///////////////////////////////////////////////////////////////////////////////////////////
function X(name)
{
window.open('em.php?x='+name,'Sending Event: '+name,'width=750,height=200,resizable=yes,scrollbars=yes,toolbar=no,location=no,directories=no,status=yes,menubar=no,copyhistory=no');
}

////////////////////////////////////////////////////////////////////////////////////
//draw circl
////////////////////////////////////////////////////////////////////////////////////
function c(x,y,rad,width,color,bkcolor,name,state,newstate,event,directevent)
{
var C=document.createElementNS(xmlns,"circle")
var Attr={r:rad,
	cx:x,
	cy:y,
	"fill": bkcolor,
	"fill-opacity":fill_opacity,
	"stroke": color,
	"id":name,
	"stroke-width":width,
	"stroke-opacity":stroke_opacity,
	"onmouseup":null,
	"onmousedown":"exec('"+name+"','"+state+"','"+newstate+"','"+event+"','"+directevent+"')",
	"onmousemove":null,
	"onmouseover":"hilight(evt,'"+name+"','"+bkcolor+"')",
	"onmouseout":"hilight(evt,'','"+bkcolor+"')"
	}
assignAttr(C,Attr);
   if (bkcolor=="none") 
        if (C.hasAttributeNS(null,"fill-opacity")) 
            C.setAttributeNS(null,"fill-opacity",transparencyopacity); 
Root.appendChild(C);
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//draw elipse
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function e(x,y,_rx,_ry,width,color,bkcolor,name,state,newstate,event,directevent){
var C=document.createElementNS(xmlns,"ellipse") 
var Attr={rx:_rx,
	ry:_ry,
	cx:x,
	cy:y,
	"fill": bkcolor,
	"fill-opacity":fill_opacity,
	"stroke": color,
	"id":name,
	"stroke-width":width,
	"stroke-opacity":stroke_opacity,
	"onmouseup":null,
	"onmousedown":"exec('"+name+"','"+state+"','"+newstate+"','"+event+"','"+directevent+"')",
	"onmousemove":null,
	"onmouseover":"hilight(evt,'"+name+"','"+bkcolor+"')",
	"onmouseout":"hilight(evt,'','"+bkcolor+"')"
	}
assignAttr(C,Attr)
   if (bkcolor=="none") 
        if (C.hasAttributeNS(null,"fill-opacity")) 
            C.setAttributeNS(null,"fill-opacity",transparencyopacity);
Root.appendChild(C)
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//draw rectangle
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function r(_x,_y,_width,_height,penwidth,color,bkcolor,name,state,newstate,event,directevent){
var C=document.createElementNS(xmlns,"rect") 
var Attr={
	 width:_width,
	 height:_height,
	 x:_x,
	 y:_y,
	"fill": bkcolor,
	"fill-opacity":fill_opacity,
	"stroke": color,
	"id":name,
	"stroke-width":penwidth,
	"stroke-opacity":stroke_opacity,
	"onmouseup":null,
	"onmousedown":"exec('"+name+"','"+state+"','"+newstate+"','"+event+"','"+directevent+"')",
	"onmousemove":null,
	"onmouseover":"hilight(evt,'"+name+"','"+bkcolor+"')",
	"onmouseout":"hilight(evt,'','"+bkcolor+"')"
	}
assignAttr(C,Attr)
   if (bkcolor=="none") 
        if (C.hasAttributeNS(null,"fill-opacity")) 
            C.setAttributeNS(null,"fill-opacity",transparencyopacity);
Root.appendChild(C)
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//draw rounded rectangle
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function rr(_x,_y,_width,_height,_rx,_ry,penwidth,color,bkcolor,name,state,newstate,event,directevent){
var C=document.createElementNS(xmlns,"rect") 
var Attr={width:_width,
	height:_height,
	rx:_rx,
	ry:_ry,
	x:_x,
	y:_y,
	"alt":name,
	"fill": bkcolor,
	"fill-opacity":fill_opacity,
	"stroke": color,
	"id":name,
	"stroke-width":penwidth,
	"stroke-opacity":stroke_opacity,
	"onmouseup":null,
	"onmousedown":"exec('"+name+"','"+state+"','"+newstate+"','"+event+"','"+directevent+"')",
	"onmousemove":null,
	"onmouseover":"hilight(evt,'"+name+"','"+bkcolor+"')",
	"onmouseout":"hilight(evt,'','"+bkcolor+"')"
	}
assignAttr(C,Attr)
   if (bkcolor=="none") 
        if (C.hasAttributeNS(null,"fill-opacity")) 
            C.setAttributeNS(null,"fill-opacity",transparencyopacity);
Root.appendChild(C)
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//draw line
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function l(_x1,_y1,_x2,_y2,penwidth,color,bkcolor,name,state,newstate,event,directevent){
var C=document.createElementNS(xmlns,"line") 
var Attr={
	 x2:_x2,
	 y2:_y2,
	 x1:_x1,
	 y1:_y1,
	"fill": bkcolor,
	"fill-opacity":fill_opacity,
	"stroke": color,
	"id":name,
	"stroke-width":penwidth,
	"stroke-opacity":stroke_opacity,
	"onmouseup":null,
	"onmousedown":"exec('"+name+"','"+state+"','"+newstate+"','"+event+"','"+directevent+"')",
	"onmousemove":null,
	"onmouseover":"hilight(evt,'"+name+"','"+bkcolor+"')",
	"onmouseout":"hilight(evt,'','"+bkcolor+"')"
	}
assignAttr(C,Attr)
if (bkcolor=="none") 
        if (C.hasAttributeNS(null,"fill-opacity")) 
            C.setAttributeNS(null,"fill-opacity",transparencyopacity); 
Root.appendChild(C)
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//draw closed path 
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function p(_points,penwidth,color,bkcolor,name,state,newstate,event,directevent){
var C=document.createElementNS(xmlns,"path") 
var Attr={
	 "d":_points,
	"fill": bkcolor,
	"fill-opacity":fill_opacity,
	"stroke-opacity":stroke_opacity,
	"stroke": color,
	"id":name,
	"stroke-width":penwidth,
	"onmouseup":null,
	"onmousedown":"exec('"+name+"','"+state+"','"+newstate+"','"+event+"','"+directevent+"')",
	"onmousemove":null,
	"onmouseover":"hilight(evt,'"+name+"','"+bkcolor+"')",
	"onmouseout":"hilight(evt,'','"+bkcolor+"')"
	}
assignAttr(C,Attr)
   if (bkcolor=="none") 
        if (C.hasAttributeNS(null,"fill-opacity")) 
            C.setAttributeNS(null,"fill-opacity",transparencyopacity);
Root.appendChild(C)
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//draw polyline
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function pl(_points,penwidth,color,bkcolor,name,state,newstate,event,directevent){
var C=document.createElementNS(xmlns,"polyline") 
var Attr={"points":_points,
	"fill": bkcolor,
	"fill-opacity":fill_opacity,
	"stroke": color,
	"id":name,
	"stroke-width":penwidth,
	"stroke-opacity":stroke_opacity,
	"onmouseup":null,
	"onmousedown":"exec('"+name+"','"+state+"','"+newstate+"','"+event+"','"+directevent+"')",
	"onmousemove":null,
	"onmouseover":"hilight(evt,'"+name+"','"+bkcolor+"')",
	"onmouseout":"hilight(evt,'','"+bkcolor+"')"
	}
assignAttr(C,Attr)
   if (bkcolor=="none") 
        if (C.hasAttributeNS(null,"fill-opacity")) 
            C.setAttributeNS(null,"fill-opacity",transparencyopacity);
Root.appendChild(C)
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//draw polygon
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function py(_points,penwidth,color,bkcolor,name,state,newstate,event,directevent){
var C=document.createElementNS(xmlns,"polygon") 
var Attr={"points":_points,
	"fill": bkcolor,
	"fill-opacity":fill_opacity,
	"stroke": color,
	"id":name,
	"stroke-width":penwidth,
	"stroke-opacity":stroke_opacity,
	"onmouseup":null,
	"onmousedown":"exec('"+name+"','"+state+"','"+newstate+"','"+event+"','"+directevent+"')",
	"onmousemove":null,
	"onmouseover":"hilight(evt,'"+name+"','"+bkcolor+"')",
	"onmouseout":"hilight(evt,'','"+bkcolor+"')"
	}
assignAttr(C,Attr)
if (bkcolor=="none") 
        if (C.hasAttributeNS(null,"fill-opacity")) 
            C.setAttributeNS(null,"fill-opacity",transparencyopacity);
Root.appendChild(C)
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//place text
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function t(_x,_y,_text,font,_size,b,u,i,penwidth,color,bkcolor,name,state,newstate,event,directevent){
if (_text.indexOf('%')>=0) return;	///do not display dynamic varibles which should be replaced by engine
var C=document.createElementNS(xmlns,"text")
var pen
if (penwidth=="none")  pen=1;
    else  pen=penwidth;
    

var Attr={"x":_x,
	 "y":_y,
	"fill": color,
	"font-family":font,
	"font-size":_size,
	"fill-opacity":fill_opacity,
	"stroke-opacity":stroke_opacity,
	"stroke": color,
	"id":name,
    //"alt":_text,
	"stroke-width":pen,
	"onmouseup":null,
	"onmousedown":"exec('"+name+"','"+state+"','"+newstate+"','"+event+"','"+directevent+"')",
	"onmousemove":null,
	"onmouseover":"hilight(evt,'"+name+"','"+bkcolor+"')",
	"onmouseout":"hilight(evt,'','"+bkcolor+"')"
	}
    assignAttr(C,Attr)
    if (bkcolor=="none") 
        if (C.hasAttributeNS(null,"fill-opacity")) 
            C.setAttributeNS(null,"fill-opacity",transparencyopacity);
    var textNode = document.createTextNode(_text);
    C.appendChild(textNode);
Root.appendChild(C)
//C.text=_text 
}
///////////////////////////////////////////////////////////////////////////////////////////////////////
function assignAttr(O,A)
	{
	for (i in A) 
       //if  (O.hasAttributeNS(null,i))
       		O.setAttributeNS(null,i, A[i])
	}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//XML verification status

function ShoweHouse1Status(index)
        {

var eol="<br>\r\n",Event,i=0,
XmlChanged=false,
XML="",
header,footer,body,bodyheader,bodyfooter;    
header="";
if (eHouse1[index].AddrH===2)
    header="\r\n";
header+="<?xml version=\"1.0\" encoding=\"UTF-8\" ?> \r\n <eHouse xmlns=\"http://www.isys.pl\" \r\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n            xsi:schemaLocation=\"http://www.openremote.org protocol.xsd\">";
header+="<Device>"+eol;
header+="<Name>"+eHouse1[index].Name+"</Name>"+eol;
header+="<Address>"+eHouse1[index].AddrH+","+eHouse1[index].AddrL+"</Address>"+eol;
//header+="<IPAddress>192.168."+DevAdrH+"."+DevAdrL+"</IPAddress>"+eol;            
//header+="<AddressCombined>"+DevAdr+"</AddressCombined>"+eol;
//header+="<StateModified>"+ehousecommunication.bo(changed)+"</StateModified>"+eol;
//header+="<ADCModified>"+ehousecommunication.bo(AdcChanged)+"</ADCModified>"+eol;
header+="<CurrentProgram>"+(eHouse1[index].CurrentProgram)+"</CurrentProgram>"+eol;
//header+="<CurrentProgramName> "+ CurrentProgramName+" </CurrentProgramName>"+eol;
//header+="<ADCCurrentProgram>"+i(ADCCurrentProgram)+"</ADCCurrentProgram>"+eol;
//header+="<ADCCurrentProgramName> "+ ADCCurrentProgramName+" </ADCCurrentProgramName>"+eol;
header+="<CurrentStatus>"+eHouse1[index].Stat+"</CurrentStatus>"+eol;
header+="<RecentStatus>"+eHouse1[index].Recent+"</RecentStatus>"+eol;
if (eHouse1[index].Type===IsRM) header+="<Devicetype>"+"RoomManager"+"</Devicetype>"+eol;
if (eHouse1[index].Type===IsEM) header+="<Devicetype>"+"ExternalManager"+"</Devicetype>"+eol;
if (eHouse1[index].Type===IsHM ) header+="<Devicetype>"+"HeatManager"+"</Devicetype>"+eol;
//if (IsLevelManager) header+="<Devicetype>"+"LevelManager"+"</Devicetype>"+eol;
//if (IsEthernet)  header+="<InterfaceType>"+"Ethernet"+"</InterfaceType>"+eol;;
        if (eHouse1[index].Type===IsEM)       //ExternalManager
            {
            header+="<CurrentZone>"+(eHouse1[index].CurrentZone)+"</CurrentZone>"+eol;
            //header+="<CurrentZoneName>"+ CurrentZoneName+"</CurrentZoneName>"+eol;

            }
bodyheader=eol+"<Outputs>"+eol;
body="";
var maxio=OUTPUTS_COUNT_RM;
if ((eHouse1[index].Type===IsRM) || (eHouse1[index].Type===IsEM)) maxio=35;
if (eHouse1[index].Type===IsHM) maxio=21;
var tmp= new Array(),m=0;        
for (var i=0;i<maxio;i++)
{
    if (((!IgnoreAtChar) || (eHouse1[index].OutsNames[i].indexOf("@")<0)))    //do not perform names currently
    
    {
    
    tmp[0]=eHouse1[index].AddrH;
    tmp[1]=eHouse1[index].AddrL;
    tmp[2]=0x1;
    tmp[3]=0;
    tmp[4]=1;
    tmp[5]=0;
    tmp[6]=0;
    tmp[7]=0;
    tmp[8]=0;
    tmp[9]=0;    
    //tmp={DevAdrH,DevAdrL,0x1,0,1,0,0,0,0,0};
    tmp[3]=i;
    var state="0",  value="Off";
            
    if (eHouse1[index].Outs[i]) {state="1";value="On";}
    body+="    <Item>"+eol+
    "        <Name>"+eHouse1[index].OutsNames[i]+"</Name>"+eol+
    "        <No>"+(i+1)+"</No>"+eol+
    "        <State>"+state+"</State>"+eol+
    "        <Value>"+value+"</Value>"+eol;
    if (eHouse1[index].Type!==IsHM)
    {
//    Event=hix(tmp,10);
//    body+="        <EventOn>"+Event+"</EventOn>"+eol;
//    tmp[4]=0;Event=hix(tmp,10);
//    body+="        <EventOff>"+Event+"</EventOff>"+eol;
//    tmp[4]=2;Event=hix(tmp,10);
//    body+="        <EventToggle>"+Event+"</EventToggle>"+eol            ;
            }
    body+="    </Item>"+eol+eol;
}
}
bodyfooter=eol+"</Outputs>"+eol;

header+=bodyheader+body+bodyfooter+eol;
bodyheader=eol+"<ADCInputs>"+eol;
body=eol;
bodyfooter=eol+"</ADCInputs>"+eol;
maxio=SENSORS_COUNT_RM;
if (eHouse1[index].Type!==IsHM) maxio=8;
for (i=0;i<maxio;i++)
{
    
if (((!IgnoreAtChar) || (eHouse1[index].ADCsNames[i].indexOf("@")<0)))    //names not performed
    {
    
  body+="    <Item>"+eol+
    "        <Name>"+eHouse1[index].ADCsNames[i]+"</Name>"+eol+
    "        <ADCValue>"+eHouse1[index].ADCs[i]+"</ADCValue>"+eol+
    "        <ADCTempValue>"+eHouse1[index].SensorTemps[i]+"</ADCTempValue>"+eol+
    "        <ADCLM335TempValue>"+eHouse1[index].SensorTemps[i]+"</ADCLM335TempValue>"+eol+
    /*"        <ADCLM35TempValue>"+SensorTempsLM35[i]+"</ADCLM35TempValue>"+eol+            
    "        <ADCMCP9700TempValue>"+SensorTempsMCP9700[i]+"</ADCMCP9700TempValue>"+eol+
    "        <ADCMCP9701TempValue>"+SensorTempsMCP9701[i]+"</ADCMCP9701TempValue>"+eol+*/
    "        <ADCPercentValue>"+eHouse1[index].SensorPercents[i]+"</ADCPercentValue>"+eol+
    "        <ADCInvertedPercentValue>"+eHouse1[index].SensorLights[i]+"</ADCInvertedPercentValue>"+eol+
    "        <ADCVoltageValue>"+eHouse1[index].SensorVolts[i]+"</ADCVoltageValue>"+eol+
    "        <ADCCalibrationValue>"+eHouse1[index].Calibration[i]+"</ADCCalibrationValue>"+eol+
    
    "        <No>"+(i+1)+"</No>"+eol
// +   "        <SensorType>"+eHouse1[index].SensorType[i]+"</SensorType>"+eol
    ;
  
    //Event=hix(tmp,10);
    //body+="        <EventOn>"+Event+"</EventOn>"+eol;
    //tmp[4]=0;Event=hix(tmp,10);
    //body+="        <EventOff>"+Event+"</EventOff>"+eol;
    //tmp[4]=2;Event=hix(tmp,10);
    //body+="        <EventToggle>"+Event+"</EventToggle>"+eol            
    /*String inversion="Normal";
    if (InputInverts[i]) inversion="Inverted";
     body+="        <Type>"+inversion+"</Type>"+eol;
     */
     body+="    </Item>"+eol+eol;}
}

header+=bodyheader+body+bodyfooter+eol;



bodyheader=eol+"<Inputs>"+eol;
body=eol;
bodyfooter=eol;
maxio=INPUTS_COUNT_RM;
//if ((eHouse1[index].Type===IsRM) || (eHouse1[index].Type===IsHM) || (eHouse1[index].Type===IsEM)) 
    maxio=12;
for (i=0;i<maxio;i++)
{
 if (((!IgnoreAtChar) || (eHouse1[index].InputsNames[i].indexOf("@")<0)))    
{
//    int tmp[]={DevAdrH,DevAdrL,0x21,0,1,0,0,0,0,0};
  //  tmp[3]=i;
    var state="0",value="On";   
    if ((eHouse1[index].Type===IsEM)) 
        {
        if (!((eHouse1[index].Inputs[i])))
            {state="1";value="Off";} 
        else
            {state="0";value="On";}
    
        }
    else
        {
        if ((!eHouse1[index].Inputs[i]))
            {state="0";value="On";} 
        else
            {state="1";value="Off";}
        }
    
    body+="    <Item>"+eol+
    "        <Name>"+eHouse1[index].InputsNames[i]+"</Name>"+eol+
            
    "        <No>"+(i+1)+"</No>"+eol+
    "        <State>"+state+"</State>"+eol+
    "        <Value>"+value+"</Value>"+eol;
    if ((eHouse1[index].Type===IsEM) ) 
        {

            
            
        if (!((eHouse1[index].AlarmSensorsActive[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}
        body+="        <ActiveState>"+state+"</ActiveState>"+eol+
        "        <ActiveValue>"+value+"</ActiveValue>"+eol;
            
            
            
/*        if (!((eHouse1[index].AlarmSensorsWarning[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}
        body+="        <WarningState>"+state+"</WarningState>"+eol+
        "        <WarningValue>"+value+"</WarningValue>"+eol;
        
        //MonitoringSensorsWarning
        
        body+="        <MonitoringState>"+state+"</MonitoringState>"+eol+
        "        <MonitoringValue>"+value+"</MonitoringValue>"+eol;
  */      
        
       if (!((eHouse1[index].AlarmSensorsAlarm[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}
        body+="        <AlarmState>"+state+"</AlarmState>"+eol+
        "        <AlarmValue>"+value+"</AlarmValue>"+eol;
        
        
        
        
        }
    //Event=hix(tmp,10);
    //body+="        <EventOn>"+Event+"</EventOn>"+eol;
    //tmp[4]=0;Event=hix(tmp,10);
    //body+="        <EventOff>"+Event+"</EventOff>"+eol;
    //tmp[4]=2;Event=hix(tmp,10);
    //body+="        <EventToggle>"+Event+"</EventToggle>"+eol            
    var inversion="Normal";
    //if (InputInverts[i]) inversion="Inverted";
     body+="        <Type>"+inversion+"</Type>"+eol;
     
     body+="    </Item>"+eol+eol;
}
}
bodyfooter=eol+"</Inputs>"+eol;

header+=bodyheader+body+bodyfooter+eol;
footer="</Device>\r\n";
footer+="\r\n</eHouse> \r\n";

XML=header+footer;
var stringToFind=">",stringToReplace="&gt;";
var inde = XML.indexOf(stringToFind);
while (inde !== -1) {
            XML = XML.replace(stringToFind, stringToReplace);
            inde = XML.indexOf(stringToFind);
        }
stringToFind="<",stringToReplace="&lt;";
inde = XML.indexOf(stringToFind);
while (inde !== -1) {
            XML = XML.replace(stringToFind, stringToReplace);
            inde = XML.indexOf(stringToFind);
        }
stringToFind="&lt;br&gt;",stringToReplace="<br>";
inde = XML.indexOf(stringToFind);
while (inde !== -1) {
            XML = XML.replace(stringToFind, stringToReplace);
            inde = XML.indexOf(stringToFind);
        }
document.writeln(XML);
}
///////////////////////////////////////////////////////////////////////////////
//Create and initialize eHouse1 object
function eHouse1Create(index)
{
var str="";
var i=0;
for (i=0;i<400;i+=1) str=str+'0';
byteVal=new Array();
eHouse1[index]=new Object();
for (i=0;i<200;i+=1) byteVal[i]=0;
//Status received from controller
eHouse1[index].Type=0;             //Type of eHouse1 Controller RM,EM,HM
eHouse1[index].Name="";             //Controller Name
eHouse1[index].Recent="";          //Recent Status Results Date
eHouse1[index].Size=0;             //Size of binary status
eHouse1[index].Stat=str;           //status writen in hex in string
eHouse1[index].PrevStat=str;       //previous status before update
eHouse1[index].BinStat=byteVal;    //status converted to binary form
//decoded status of controller to object
eHouse1[index].AddrH=0;            //Address High of controller
eHouse1[index].AddrL=0;            //Address Low of controller
eHouse1[index].Outs=new Array();     //Outputs States
eHouse1[index].OutsNames=new Array();     //Outputs States
for (i=0;i<OUTPUTS_COUNT_RM;i+=1) 
    {
    eHouse1[index].Outs[i]=false;  //Initialize with false
    eHouse1[index].OutsNames[i]="Out "+(i+1);  //Initialize with false
    }
eHouse1[index].Inputs=new Array();   //Input states;
eHouse1[index].InputsNames=new Array();   //Input Names
for (i=0;i<INPUTS_COUNT_RM;i+=1) 
    {
    eHouse1[index].InputsNames[i]="In "+(i+1);  //Initialize with false
    eHouse1[index].Inputs[i]=false;  //Initialize with false
    }
eHouse1[index].CurrentProgram=0;   //Current Program
eHouse1[index].Dimmers=new Array();   //Dimmers
eHouse1[index].DimmerRGB=0;            //RGB dimmer combined
for (i=0;i<3;i+=1) eHouse1[index].Dimmers[i]=0;  //Initialize with 0
eHouse1[index].ADCs=new Array();            //ADC Absolute Values
eHouse1[index].ADCsNames=new Array();            //ADC Names
eHouse1[index].SensorTemps=new Array();     //ADC calculate temp value
eHouse1[index].SensorPercents =new Array(); //ADC calculate percent value
eHouse1[index].SensorLights=new Array();    //ADC calculate inverted percent or light level
eHouse1[index].SensorVolts=new Array();     //ADC measure voltage 
eHouse1[index].Calibration=new Array();     //Calibration value Offset for ADC measurment
eHouse1[index].VCC=5000;                    //Power Voltage for calibration 
for (i=0;i<SENSORS_COUNT_RM;i+=1) 
    {
    eHouse1[index].ADCs[i]=0;  //Initialize with 0
    eHouse1[index].ADCsNames[i]="ADC "+(i+1);  //Initialize with 0
    eHouse1[index].SensorTemps[i] = 0;    //calculate temp value
    eHouse1[index].SensorPercents[i] = 0;  //calculate percent value
    eHouse1[index].SensorLights[i]=100;
   
    eHouse1[index].SensorVolts[i]=0;
    eHouse1[index].Calibration[i]=-27315;
    }
eHouse1[index].AlarmSensorsActive= new Array();//[128]
eHouse1[index].AlarmSensorsAlarm =new Array();//[128]
eHouse1[index].AlarmSensorsName =new Array();//[128]
for (i=0;i<128;i+=1) 
    {
    eHouse1[index].AlarmSensorsName[i]="Sensor "+(i+1);     //Outputs States
    eHouse1[index].AlarmSensorsActive[i]=false;  //Initialize with false
    eHouse1[index].AlarmSensorsAlarm[i]=false;  //Initialize with false
    }
eHouse1[index].CurrentZone=0;
}
/////////////////////////////////////////////////////////////////////////////////
//Ethernet eHouse controler instance create / initialize
function EthernetEhouseCreate(index)
{
var str="";
var i=0;
for (i=0;i<400;i+=1) str=str+'0';
byteVal=new Array();
EthernetEhouse[index]=new Object();
for (i=0;i<200;i+=1) byteVal[i]=0;
//Status received from controller
EthernetEhouse[index].Type=0;             //Type of eHouse1 Controller RM,EM,HM
EthernetEhouse[index].Name="";             //Controller Name
EthernetEhouse[index].Recent="";          //Recent Status Results Date
EthernetEhouse[index].Size=0;             //Size of binary status
EthernetEhouse[index].Stat=str;           //status writen in hex in string
EthernetEhouse[index].PrevStat=str;       //previous status before update
EthernetEhouse[index].BinStat=byteVal;    //status converted to binary form
//decoded status of controller to object
EthernetEhouse[index].AddrH=0;            //Address High of controller
EthernetEhouse[index].AddrL=0;            //Address Low of controller
EthernetEhouse[index].Outs=new Array();     //Outputs States
EthernetEhouse[index].OutsNames=new Array();     //Outputs States

for (i=0;i<OUTPUTS_COUNT_ERM;i+=1) 
    {
    EthernetEhouse[index].Outs[i]=false;  //Initialize with false
    EthernetEhouse[index].OutsNames[i]="Out "+(i+1);  //Initialize with false
    }
EthernetEhouse[index].Inputs=new Array();   //Input states;
EthernetEhouse[index].InputInverts=new Array();//Inversion of input
EthernetEhouse[index].InputsNames=new Array();   //Input Names
for (i=0;i<INPUTS_COUNT_ERM;i+=1) 
    {
    EthernetEhouse[index].InputInverts[i]=0;            //Inversion =false;
    EthernetEhouse[index].InputsNames[i]="In "+(i+1);  //Initialize with false
    EthernetEhouse[index].Inputs[i]=false;  //Initialize with false
    }
EthernetEhouse[index].CurrentProgram=0;   //Current Program
EthernetEhouse[index].Dimmers=new Array();   //Dimmers
EthernetEhouse[index].DimmerRGB=0;            //RGB dimmer combined
for (i=0;i<3;i+=1) EthernetEhouse[index].Dimmers[i]=0;  //Initialize with 0
EthernetEhouse[index].ADCs=new Array();            //ADC Absolute Values
EthernetEhouse[index].ADCsNames=new Array();            //ADC Names
EthernetEhouse[index].SensorTemps=new Array();     //ADC calculate temp value
EthernetEhouse[index].SensorPercents =new Array(); //ADC calculate percent value
EthernetEhouse[index].SensorLights=new Array();    //ADC calculate inverted percent or light level
EthernetEhouse[index].SensorVolts=new Array();     //ADC measure voltage 
EthernetEhouse[index].Calibration=new Array();     //Calibration value Offset for ADC measurment
EthernetEhouse[index].SensorTempsMCP9700 = new Array();    //calculate temp value from MCP9700
EthernetEhouse[index].SensorTempsMCP9701 = new Array();    //calculate temp value from MCP9701
EthernetEhouse[index].SensorTempsLM35    =new Array(); //LM35 calculate temperature sensor
EthernetEhouse[index].VCC=3300;                    //Power Voltage for calibration 
for (i=0;i<SENSORS_COUNT_ERM;i+=1) 
    {
    EthernetEhouse[index].ADCs[i]=0;                    //Initialize with 0
    EthernetEhouse[index].ADCsNames[i]="ADC "+(i+1);    //Initialize with 0
    EthernetEhouse[index].SensorTemps[i] = 0;           //calculate temp value
    EthernetEhouse[index].SensorTempsMCP9700[i] = 0;    //calculate temp value
    EthernetEhouse[index].SensorTempsMCP9701[i] = 0;    //calculate temp value
    EthernetEhouse[index].SensorPercents[i] = 0;        //calculate percent value
    EthernetEhouse[index].SensorLights[i]=100;
   EthernetEhouse[index].SensorTempsLM35[i]=0;          
    EthernetEhouse[index].SensorVolts[i]=0;
    EthernetEhouse[index].Calibration[i]=//-4000;
    MCP9700_Offset;//=-500; //Offset voltage at 0C [mV]
    //MCP9701_Offset;//=-400; //Offset voltage at 0C [mV]
    
    }
EthernetEhouse[index].AlarmSensorsActive    = new Array();//[128]
EthernetEhouse[index].AlarmSensorsAlarm     = new Array();//[128]
EthernetEhouse[index].AlarmSensorsName      = new Array();//[128]
EthernetEhouse[index].AlarmSensorsWarning   = new Array();  //Initialize with false
EthernetEhouse[index].AlarmSensorsMonitoring= new Array();  //Initialize with false
for (i=0;i<ALARM_SENSORS_COUNT_ERM;i+=1) 
    {
    EthernetEhouse[index].AlarmSensorsName[i]       ="Sensor "+(i+1);     //Outputs States
    EthernetEhouse[index].AlarmSensorsActive[i]     =false;  //Initialize with false
    EthernetEhouse[index].AlarmSensorsAlarm[i]      =false;  //Initialize with false
    EthernetEhouse[index].AlarmSensorsWarning[i]    =false;  //Initialize with false
    EthernetEhouse[index].AlarmSensorsMonitoring[i] =false;  //Initialize with false
    }
EthernetEhouse[index].CurrentZone=0;
EthernetEhouse[index].CurrentADCProgram=0;
}





/////////////////////////////////////////////////////////////////////////////////
//Get Ethernet Ehouse status writen as string and convert to binary status and decoding
function GetEthernetEhouseStatus(index)
{
if (EthernetEhouse[index].PrevStat===EthernetEhouse[index].Stat) return;   //the same data
EthernetEhouse[index].PrevStat=EthernetEhouse[index].Stat;                //Update Previous state to ignore if no data reception for current controller
hex2binEth(index); //convert text - hex status to binary data -> eHouse1[index].BinStat;
DecodeEthernetEhouseStatus(index); //decode status of eHouse1 controller from binary status data
ShowEthernetEhouseStatus(index);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function ginv(val, inv)

{
if (IsCommManager)  return val^inv;
else return (!val)^inv;
}
//
////////////////////////////////////////////////////////////////////////////////

function DecodeEthernetEhouseStatus(index)

        { var i,k,        TotalOffset=STATUS_TCP_OFFSET;
        //if (ehousecommunication.disablestatperforme) return true;
        //if (IsCommManager) 
            TotalOffset+=STATUS_COMMMANAGER_OFFSET;
        

        var Max_ADC = 16;
        

        //int CurrentSize=dta[0]&0xff;
        //
        //Calendar c = Calendar.getInstance(); 
        //recent=c.getTime().toLocaleString();
        //if (ehousecommunication.disablestatperforme) return true;
        {   //update data
        
        //if ((IsERM) || (IsEEM)) Max_ADC=8;
        
        {
            
//            if ((IsERM) && (!InitFromPrevious))                CurrentStatus[STATUS_SIZE-1] = 0;
            
            //Update All Outputs
            for (k = 0; k < 8; k++)
                {   ///output states
                    EthernetEhouse[index].Outs[k] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C]&0xff, k);
                    EthernetEhouse[index].Outs[k + 8]  = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 1]&0xff, k);
                    EthernetEhouse[index].Outs[k + 16] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 2]&0xff, k);
                    EthernetEhouse[index].Outs[k + 24] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 3]&0xff, k);
                    
                    
                    EthernetEhouse[index].Outs[k+32] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C+4]&0xff, k);
                    EthernetEhouse[index].Outs[k + 40]  = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 5]&0xff, k);
                    EthernetEhouse[index].Outs[k + 48] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 6]&0xff, k);
                    EthernetEhouse[index].Outs[k + 56] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C+7]&0xff, k);
                    EthernetEhouse[index].Outs[k+64] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C+8]&0xff, k);
                    EthernetEhouse[index].Outs[k + 72]  = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 9]&0xff, k);
/*                    EthernetEhouse[index].Outs[k + 80] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 10]&0xff, k);
                    EthernetEhouse[index].Outs[k + 88] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C+11]&0xff, k);
                    EthernetEhouse[index].Outs[k + 96] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 12]&0xff, k);
                    EthernetEhouse[index].Outs[k + 104] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C+13]&0xff, k);
                    EthernetEhouse[index].Outs[k+112] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C+14]&0xff, k);
                    EthernetEhouse[index].Outs[k + 120]  = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 15]&0xff, k);
                    EthernetEhouse[index].Outs[k + 128] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 16]&0xff, k);
                    EthernetEhouse[index].Outs[k + 136] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C+17]&0xff, k);
                    EthernetEhouse[index].Outs[k+144] = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C+18]&0xff, k);
                    EthernetEhouse[index].Outs[k + 152]  = GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_OUT_I2C + 19]&0xff, k);
                */
                    EthernetEhouse[index].Inputs[k]       = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].Inputs[k+8]     = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+1]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].Inputs[k+16]       = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+2]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].Inputs[k+24]     = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+3]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].Inputs[k+32]       = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+4]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].Inputs[k+40]     = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+5]&0xff, k),EthernetEhouse[index].InputInverts[k]);
/*                    EthernetEhouse[index].Inputs[k+48]       = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+6]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].Inputs[k+56]     = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+7]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].Inputs[k+64]       = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+8]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].Inputs[k+72]     = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+9]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].Inputs[k+80]       = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+10]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].Inputs[k+88]     = ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+11]&0xff, k),EthernetEhouse[index].InputInverts[k]);
  */                  
                    
                    //Security sensors status Alarm, Warning, Monitoring Mask violations
                if (EthernetEhouse[index].Type===IsCommManager)
                    {
                        ////active sensors - inputs
                    EthernetEhouse[index].AlarmSensorsActive[k] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 8] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C + 1]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 16] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C + 2]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 24] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C + 3]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 32] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C + 4]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 40] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C + 5]&0xff, k),EthernetEhouse[index].InputInverts[k]);
/*                    EthernetEhouse[index].AlarmSensorsActive[k + 48] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+6]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 56] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+7]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 64] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+8]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 72] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+9]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 80] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+10]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsActive[k + 88] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_INPUTS_I2C+11]&0xff, k),EthernetEhouse[index].InputInverts[k]);
  */                  EthernetEhouse[index].AlarmSensorsAlarm[k] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 8] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 1]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 16] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 2]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 24] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 3]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 32] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 4]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 40] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 5]&0xff, k),EthernetEhouse[index].InputInverts[k]);
    /*                EthernetEhouse[index].AlarmSensorsAlarm[k + 48] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 6]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 56] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 7]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 64] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 8]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 72] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 9]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 80] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 10]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsAlarm[k + 88] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_ALARM_I2C + 11]&0xff, k),EthernetEhouse[index].InputInverts[k]);
      */              EthernetEhouse[index].AlarmSensorsWarning[k] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 8] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 1]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 16] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 2]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 24] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 3]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 32] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 4]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 40] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 5]&0xff, k),EthernetEhouse[index].InputInverts[k]);
        /*            EthernetEhouse[index].AlarmSensorsWarning[k + 48] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 6]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 56] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 7]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 64] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 8]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 72] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 9]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 80] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 10]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsWarning[k + 88] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_WARNING_I2C + 11]&0xff, k),EthernetEhouse[index].InputInverts[k]);
          */          EthernetEhouse[index].AlarmSensorsMonitoring[k] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 8] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 1]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 16] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 2]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 24] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 3]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 32] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 4]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 40] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 5]&0xff, k),EthernetEhouse[index].InputInverts[k]);
            /*        EthernetEhouse[index].AlarmSensorsMonitoring[k + 48] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 6]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 56] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 7]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 64] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 8]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 72] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 9]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 80] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 10]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    EthernetEhouse[index].AlarmSensorsMonitoring[k + 88] =ginv( GetInOutValue(EthernetEhouse[index].BinStat[TotalOffset+STATUS_MONITORING_I2C + 11]&0xff, k),EthernetEhouse[index].InputInverts[k]);
                    
*/
                    }
                }

            EthernetEhouse[index].CurrentProgram=EthernetEhouse[index].BinStat[TotalOffset+STATUS_PROGRAM_NR]&0xff;
            EthernetEhouse[index].CurrentZone = EthernetEhouse[index].BinStat[TotalOffset+STATUS_ZONE_NR]&0xff;            
            //CurrentProgramName="";
            //if (EthernetEhouse[index].CurrentZone<ZONES_MAX)
              //  CurrentZoneName=ZoneNames[CurrentZone];
            //else CurrentZoneName="-";
            //if (CurrentZoneName==null) CurrentZoneName="";
            //ADCCurrentProgramName="";
            
            }
/*        if (IsTCPEM)
        {
            CurrentProgramName = "";
        }*/
/*        if (IsTCPHM) 
            {
            Max_ADC=16;
            CurrentProgram = CurrentStatus[HM_STATUS_PROGRAM];
            CurrentProgramName = "";//na razie
            for (k = 0; k < 8; k++)
                {
                int mm = 0;
                sss=k;UpdateIOStatus(OutputStates[sss],OutputViewH[sss],OutputViewL[sss],GRAPHICS_OBJECTS_MAX);
                OutputStates[k] = GetInOutValue(CurrentStatus[HM_STATUS_OUT], k);
                sss=k+8;UpdateIOStatus(OutputStates[sss],OutputViewH[sss],OutputViewL[sss],GRAPHICS_OBJECTS_MAX);
                OutputStates[k + 8] = GetInOutValue(CurrentStatus[HM_STATUS_OUT + 1], k); //bitoffset++; k++;
                sss=k+16;UpdateIOStatus(OutputStates[sss],OutputViewH[sss],OutputViewL[sss],GRAPHICS_OBJECTS_MAX);
                OutputStates[k + 16] = GetInOutValue(CurrentStatus[HM_STATUS_OUT + 2], k); //bitoffset++; k++;
//                InputStates[k] = GetInOutValue(CurrentStatus[RM_STATUS_IN ], k);
  //              InputStates[k + 8] = GetInOutValue(CurrentStatus[RM_STATUS_INT ], k);
                }
            }*/
        i=0;
        while (i < Max_ADC)
                {                                               //offset od 2                       //offset od 2
                var temppp= EthernetEhouse[index].BinStat[TotalOffset+i * 2 + 1 ]&0xff;
                if (temppp<0) temppp+=256;
                 temppp+=((EthernetEhouse[index].BinStat[TotalOffset+i * 2 ]&0xff) << 8);
                    EthernetEhouse[index].ADCs[i] = temppp;
                    EthernetEhouse[index].SensorTemps[i] = gettemplm(temppp, EthernetEhouse[index].Calibration[i], 10, EthernetEhouse[index].VCC);
                    EthernetEhouse[index].SensorPercents[i] = calculate_percent(temppp);
                    EthernetEhouse[index].SensorLights[i] = 100-EthernetEhouse[index].SensorPercents[i]; //inverted percent
                    EthernetEhouse[index].SensorTempsLM35[i]=gettemplm35(temppp,EthernetEhouse[index].VCC,EthernetEhouse[index].Calibration[i]);
                    EthernetEhouse[index].SensorTempsMCP9700[i]=calculate_MCP9700Eth(temppp,EthernetEhouse[index].VCC,EthernetEhouse[index].Calibration[i]);
                    EthernetEhouse[index].SensorTempsMCP9701[i]=calculate_MCP9701Eth(temppp,EthernetEhouse[index].VCC,EthernetEhouse[index].Calibration[i]);
                    EthernetEhouse[index].SensorVolts[i]=calculate_voltage(temppp,EthernetEhouse[index].VCC);
                    i++;
                }
        
        }
        }


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Show Ethernet status XML
function ShowEthernetEhouseStatus(index)
        {    
            //this.
            
{

var eol="\r\n<br>\r\n",Event,XML="";;

var header,footer,body,bodyheader,bodyfooter;    
header="<?xml version=\"1.0\" encoding=\"UTF-8\" ?> \r\n <eHouse xmlns=\"http://www.isys.pl\" \r\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n            xsi:schemaLocation=\"http://www.openremote.org protocol.xsd\">";
header+="<Device>"+eol;
header+="<Name>"+EthernetEhouse[index].Name+"</Name>"+eol;
header+="<Address>"+EthernetEhouse[index].AddrH+","+EthernetEhouse[index].AddrL+"</Address>"+eol;
header+="<IPAddress>192.168."+EthernetEhouse[index].AddrH+"."+EthernetEhouse[index].AddrL+"</IPAddress>"+eol;            
header+="<AddressCombined>"+EthernetEhouse[index].Addr+"</AddressCombined>"+eol;
//header+="<StateModified>"+ehousecommunication.bo(changed)+"</StateModified>"+eol;
//header+="<ADCModified>"+ehousecommunication.bo(AdcChanged)+"</ADCModified>"+eol;
header+="<CurrentProgram>"+EthernetEhouse[index].CurrentProgram+"</CurrentProgram>"+eol;
//header+="<CurrentProgramName> "+ CurrentProgramName+" </CurrentProgramName>"+eol;
header+="<ADCCurrentProgram>"+EthernetEhouse[index].ADCCurrentProgram+"</ADCCurrentProgram>"+eol;
//header+="<ADCCurrentProgramName> "+ ADCCurrentProgramName+" </ADCCurrentProgramName>"+eol;
header+="<CurrentStatus>"+EthernetEhouse[index].Stat+"</CurrentStatus>"+eol;
//header+="<RecentStatus>"+EthernetEhouse[index].recent+"</RecentStatus>"+eol;
if (EthernetEhouse[index].Type===IsERM) header+="<Devicetype>"+"EthernetRoomManager"+"</Devicetype>"+eol;
if (EthernetEhouse[index].Type===IsCommManager) header+="<Devicetype>"+"CommManager"+"</Devicetype>"+eol;
if (EthernetEhouse[index].Type===IsEHM ) header+="<Devicetype>"+"EthernetRoomManager"+"</Devicetype>"+eol;
if (EthernetEhouse[index].Type===IsLevelManager) header+="<Devicetype>"+"LevelManager"+"</Devicetype>"+eol;
//if (IsEthernet)  header+="<InterfaceType>"+"Ethernet"+"</InterfaceType>"+eol;;
        if (EthernetEhouse[index].Type===IsCommManager)       //communicationManager
            {
            header+="<CurrentZone>"+EthernetEhouse[index].CurrentZone+"</CurrentZone>"+eol;
//            header+="<CurrentZoneName>"+ CurrentZoneName+"</CurrentZoneName>"+eol;

            }
bodyheader=eol+"<Outputs>"+eol;
body="";
var maxio=OUTPUTS_COUNT_ERM;
if ((EthernetEhouse[index].Type===IsERM) || (EthernetEhouse[index].Type===IsEHM) || (EthernetEhouse[index].Type===IsEEM)) maxio=40;
for (var i=0;i<maxio;i++)
{    
if (((!IgnoreAtChar) || (EthernetEhouse[index].OutsNames[i].indexOf("@")<0)))    
    {
    
    var tmp=new Array();
    tmp[0]=EthernetEhouse[index].AddrH;
    tmp[1]=EthernetEhouse[index].AddrL;
    tmp[2]=0x21;
    tmp[3]=0;
    tmp[4]=1;
    tmp[5]=0;
    tmp[6]=0;
    tmp[7]=0;
    tmp[8]=0;
    tmp[9]=0;
    
    tmp[3]=i;
    var state="0", value="Off";   if (EthernetEhouse[index].Outs[i]) {state="1";value="On";}
    body+="    <Item>"+eol+
    "        <Name>"+EthernetEhouse[index].OutsNames[i]+"</Name>"+eol+
    "        <No>"+(i+1)+"</No>"+eol+
    "        <State>"+state+"</State>"+eol+
    "        <Value>"+value+"</Value>"+eol;
//    Event=hix(tmp,10);
//    body+="        <EventOn>"+Event+"</EventOn>"+eol;
//    tmp[4]=0;Event=hix(tmp,10);
//    body+="        <EventOff>"+Event+"</EventOff>"+eol;
//    tmp[4]=2;Event=hix(tmp,10);
//    body+="        <EventToggle>"+Event+"</EventToggle>"+eol;            
   body +="    </Item>"+eol+eol;
    }
}
bodyfooter=eol+"</Outputs>"+eol;

header+=bodyheader+body+bodyfooter+eol;
bodyheader=eol+"<ADCInputs>"+eol;
body=eol;
bodyfooter=eol+"</ADCInputs>"+eol;
var maxio=SENSORS_COUNT_ERM;
for (var i=0;i<maxio;i++)
{
 if (((!IgnoreAtChar) || (EthernetEhouse[index].ADCsNames[i].indexOf("@")<0)))    
    {
        body+="    <Item>"+eol+
    "        <Name>"+EthernetEhouse[index].ADCsNames[i]+"</Name>"+eol+
    "        <ADCValue>"+EthernetEhouse[index].ADCs[i]+"</ADCValue>"+eol+
    "        <ADCTempValue>"+EthernetEhouse[index].SensorTemps[i]+"</ADCTempValue>"+eol+
    "        <ADCLM335TempValue>"+EthernetEhouse[index].SensorTemps[i]+"</ADCLM335TempValue>"+eol+
    "        <ADCLM35TempValue>"+EthernetEhouse[index].SensorTempsLM35[i]+"</ADCLM35TempValue>"+eol+            
    "        <ADCMCP9700TempValue>"+EthernetEhouse[index].SensorTempsMCP9700[i]+"</ADCMCP9700TempValue>"+eol+
    "        <ADCMCP9701TempValue>"+EthernetEhouse[index].SensorTempsMCP9701[i]+"</ADCMCP9701TempValue>"+eol+
    "        <ADCPercentValue>"+EthernetEhouse[index].SensorPercents[i]+"</ADCPercentValue>"+eol+
    "        <ADCInvertedPercentValue>"+EthernetEhouse[index].SensorLights[i]+"</ADCInvertedPercentValue>"+eol+
    "        <ADCVoltageValue>"+EthernetEhouse[index].SensorVolts[i]+"</ADCVoltageValue>"+eol+
    "        <ADCCalibrationValue>"+EthernetEhouse[index].Calibration[i]+"</ADCCalibrationValue>"+eol+
    
    "        <No>"+(i+1)+"</No>"+eol;
//    "        <SensorType>"+SensorType[i]+"</SensorType>"+eol+
//    "        <SensorTypeName>"+SensorTypeName[i]+"</SensorTypeName>"+eol;
    //Event=hix(tmp,10);
    //body+="        <EventOn>"+Event+"</EventOn>"+eol;
    //tmp[4]=0;Event=hix(tmp,10);
    //body+="        <EventOff>"+Event+"</EventOff>"+eol;
    //tmp[4]=2;Event=hix(tmp,10);
    //body+="        <EventToggle>"+Event+"</EventToggle>"+eol            
    /*String inversion="Normal";
    if (InputInverts[i]) inversion="Inverted";
     body+="        <Type>"+inversion+"</Type>"+eol;
     */
     body+="    </Item>"+eol+eol;
    }
}

header+=bodyheader+body+bodyfooter+eol;



bodyheader=eol+"<Inputs>"+eol;
body=eol;
bodyfooter=eol;
maxio=INPUTS_COUNT_ERM;
if ((EthernetEhouse[index].Type===IsERM) || (EthernetEhouse[index].Type===IsEHM) || (EthernetEhouse[index].Type===IsEEM)) maxio=16;
for (var i=0;i<maxio;i++)
{
    
if (((IgnoreAtChar) || (EthernetEhouse[index].InputNames[i].indexOf("@")<0)))    
{
//    int tmp[]={DevAdrH,DevAdrL,0x21,0,1,0,0,0,0,0};
  //  tmp[3]=i;
    var state="0", value="Off";   
    /*if ((IsCommManager) || (IsLevelManager)) 
        {
        if (!((InputStates[i])^(InputInverts[i])))
            {state="1";value="Off";} 
        else
            {state="0";value="On";}
    
        }
    else
        {
        if ((InputStates[i])^(InputInverts[i]))
            {state="0";value="On";} 
        else
            {state="1";value="Off";}
        }*/
    if (((EthernetEhouse[index].Inputs[i])))
            {state="1";value="On";} 
        else
            {state="0";value="Off";}
    
    body+="    <Item>"+eol+
    "        <Name>"+EthernetEhouse[index].InputsNames[i]+"</Name>"+eol+
            
    "        <No>"+(i+1)+"</No>"+eol+
    "        <State>"+state+"</State>"+eol+
    "        <Value>"+value+"</Value>"+eol;
    if ((IsCommManager) || (IsLevelManager)) 
        {

            
if (((EthernetEhouse[index].AlarmSensorsActive[i])))
            {state="1";value="On";} 
        else
            {state="0";value="Off";}            
        /*if (!((AlarmSensorsActive[i])^(InputInverts[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}*/
        body+="        <ActiveState>"+state+"</ActiveState>"+eol+
        "        <ActiveValue>"+value+"</ActiveValue>"+eol;
          
if (((EthernetEhouse[index].AlarmSensorsWarning[i])))
            {state="1";value="On";} 
        else
            {state="0";value="Off";}            
/*            
        if (!((AlarmSensorsWarning[i])^(InputInverts[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}*/
        body+="        <WarningState>"+state+"</WarningState>"+eol+
        "        <WarningValue>"+value+"</WarningValue>"+eol;
        
        //MonitoringSensorsWarning
        if (((EthernetEhouse[index].AlarmSensorsMonitoring[i])))
            {state="1";value="On";} 
        else
            {state="0";value="Off";}
        /*if (!((AlarmSensorsMonitoring[i])^(InputInverts[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}*/
        body+="        <MonitoringState>"+state+"</MonitoringState>"+eol+
        "        <MonitoringValue>"+value+"</MonitoringValue>"+eol;
        
        if (((EthernetEhouse[index].AlarmSensorsAlarm[i])))
            {state="1";value="On";} 
        else
            {state="0";value="Off";}
       /*if (!((AlarmSensorsAlarm[i])^(InputInverts[i])))
            {state="0";value="Off";} 
        else
            {state="1";value="On";}*/
        body+="        <AlarmState>"+state+"</AlarmState>"+eol+
        "        <AlarmValue>"+value+"</AlarmValue>"+eol;
        
        
        
        
        }
    //Event=hix(tmp,10);
    //body+="        <EventOn>"+Event+"</EventOn>"+eol;
    //tmp[4]=0;Event=hix(tmp,10);
    //body+="        <EventOff>"+Event+"</EventOff>"+eol;
    //tmp[4]=2;Event=hix(tmp,10);
    //body+="        <EventToggle>"+Event+"</EventToggle>"+eol            
    var inversion="Normal";
    if (EthernetEhouse[index].InputInverts[i]) inversion="Inverted";
     body+="        <Type>"+inversion+"</Type>"+eol;
     
     body+="    </Item>"+eol+eol;
}
}
bodyfooter=eol+"</Inputs>"+eol;

header+=bodyheader+body+bodyfooter+eol;
footer="</Device>\r\n";
footer+="\r\n</eHouse> \r\n";


XML= header+footer;
var stringToFind=">",stringToReplace="&gt;";
var inde = XML.indexOf(stringToFind);
while (inde !== -1) {
            XML = XML.replace(stringToFind, stringToReplace);
            inde = XML.indexOf(stringToFind);
        }
stringToFind="<",stringToReplace="&lt;";
inde = XML.indexOf(stringToFind);
while (inde !== -1) {
            XML = XML.replace(stringToFind, stringToReplace);
            inde = XML.indexOf(stringToFind);
        }
stringToFind="&lt;br&gt;",stringToReplace="<br>";
inde = XML.indexOf(stringToFind);
while (inde !== -1) {
            XML = XML.replace(stringToFind, stringToReplace);
            inde = XML.indexOf(stringToFind);
        }
        
//XML=XML.replaceAll(">","&gt;");
//XML=XML.replaceAll("<","&lt;");
document.writeln(XML);
}
	}

    
 

